/*------------------------------------------------------------------------------
						SEPIA
------------------------------------------------------------------------------*/
#include "injFX_Shaders\ColorTones.h"

float4 SepiaPass( float4 colorInput, float2 tex )
{
	float4 sepia = colorInput;
	// Validating user input
	float GreyPower2 = 0;
	float SepiaPower2 =0;
	if (GreyPower < 1 || GreyPower > 9) GreyPower2 = 0;
	else GreyPower2 = GreyPower * 0.11;
	if (SepiaPower < 1 || SepiaPower > 9) SepiaPower2 = 0;
	else SepiaPower2 = SepiaPower * 0.11;
	// Calculating amounts of input, grey and sepia colors to blend and combine
	float grey = dot(sepia.rgb, float4(0.3, 0.59, 0.11, 0));
	sepia.rgb = float4(sepia.rgb * ColorShade , 1);
	float4 grey2 = grey * (GreyPower2);
	float4 color2 = colorInput / (GreyPower2 + 1);
	float4 blend2 = grey2 + color2;
	sepia.rgb = lerp(blend2, sepia.rgb, SepiaPower2);
	// returning the final color
	return sepia;
}
